"""
Copyright (c) 2022 Magic Object <https://www.magic-object.mydns.jp/>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; If not, see <https://www.gnu.org/licenses/>.
"""
from krita import Krita, Extension
####################################################################

class TensyaExtension(Extension):
    """
    このクラスは転写を行います。
    """
    def __init__(self, parent):
        super(TensyaExtension, self).__init__(parent)

    def setup(self):
        pass

    def createActions(self, window):
        action = window.createAction("tensya", "転写", "layer")
        action.triggered.connect(self.do)

    def do(self):

        application = Krita.instance()

        currentDocument = application.activeDocument()
        if not currentDocument:
            return

        currentLayer = currentDocument.activeNode()
        if not currentLayer:
            return

        layerName = currentLayer.name()
        layerType = currentLayer.type()
        parentNode = currentLayer.parentNode()

        mergedLayer = currentLayer.mergeDown()
        newLayer = currentDocument.createNode( layerName, layerType )
        parentNode.addChildNode( newLayer, mergedLayer )
####################################################################
Krita.instance().addExtension(TensyaExtension(Krita.instance()))
