#!/usr/bin/env python
# -*- coding: utf-8 -*-
#

import re
import subprocess
import shlex
import os
import sys
import argparse
import shutil


#########################################################################
# start class FilePath
#########################################################################
class FilePath:
    #########################################################################
    scriptFullPath = __file__
    scriptDirPath = ''
    scriptRealPath = ''
    scriptRealDirPath = ''

    #########################################################################
    def __init__(self):
        self.scriptFullPath = os.path.abspath(__file__)
        self.scriptDirPath = os.path.dirname(self.scriptFullPath)
        if self.scriptDirPath.endswith('/'):
            self.scriptDirPath = self.scriptDirPath.rstrip('/')

        self.scriptRealPath = os.path.realpath(self.scriptFullPath)
        self.scriptRealDirPath = os.path.dirname(self.scriptRealPath)
        if self.scriptRealDirPath.endswith('/'):
            self.scriptRealDirPath = self.scriptRealDirPath.rstrip('/')
        #########################################################################


#########################################################################
# end class ShellCommand
#########################################################################

#########################################################################
# Start Main
#########################################################################
if __name__ == '__main__':

    filesDirName = 'files'

    if os.geteuid() != 0:
        sys.stderr.write('このツールを利用するには管理者権限が必要です。\n')
        exit(1)

    parser = argparse.ArgumentParser(description='firewalld_ipblock をインストールするツールです。')
    parser.add_argument('-v', '--version', action='version', version='%(prog)s 1.0')
    parser.add_argument('--prefix', help='インストール先のディレクトリ', default='/usr/local', nargs=1)
    parser.add_argument('-u', '--uninstall', help='インストールしたファイルを削除する', action='store_true', default=False)
    args = parser.parse_args()

    installTargetPath = args.prefix
    if isinstance(installTargetPath, list):
        installTargetPath = installTargetPath[0]

    if not os.path.isdir(installTargetPath) or not os.access(installTargetPath, os.W_OK):
        print('インストール先は、書き込み可能なディレクトリでなければなりません。')
        exit(1)

    #########################################################################
    if not args.uninstall:
        #########################################################################
        print('FirewallD をチェックします.....')
        with open(os.devnull, 'wb') as devnull:
            if 0 != subprocess.call(['service', 'firewalld', 'status'], stdout=devnull, stderr=subprocess.STDOUT):
                print('FirewallD が動作していません。')
                exit(1)
            else:
                print('OK')
    #########################################################################
    pathAction = FilePath()
    filesDirPath = os.path.join(pathAction.scriptDirPath, filesDirName)
    filesDirPath = os.path.abspath(filesDirPath)

    if not os.path.isdir(filesDirPath) or not os.access(filesDirPath, os.R_OK):
        print('インストールデータが読み込めません。')
        exit(1)

    if args.uninstall:  # アンインストール
        #########################################################################
        errorSomeErase = False
        for (dirPath, dirNames, fileNames) in os.walk(filesDirPath):

            installToDirPath = dirPath[len(filesDirPath):]
            if installToDirPath.startswith('/'):
                installToDirPath = installToDirPath[1:]

            for fileName in fileNames:
                newInstalledFilePath = os.path.join(installTargetPath, installToDirPath, fileName)
                if not os.path.islink(newInstalledFilePath) and not os.path.isfile(newInstalledFilePath):
                    continue

                try:
                    os.remove(newInstalledFilePath)
                    print('ファイル「' + newInstalledFilePath + '」を削除しました。')
                except:
                    print('ファイル「' + newInstalledFilePath + '」の削除に失敗しました。')
                    errorSomeErase = True

            if len(fileNames) > 0:
                targetDirPath = os.path.join(installTargetPath, installToDirPath)
                if targetDirPath.endswith('/'):
                    targetDirPath = targetDirPath.rstrip('/')

                if os.path.exists(targetDirPath) and 'firewalld_ipblock' == os.path.basename(targetDirPath):
                    try:
                        os.rmdir(targetDirPath)
                        print('ディレクトリ「' + targetDirPath + '」を削除しました。')
                    except:
                        print('ディレクトリ「' + targetDirPath + '」の削除に失敗しました。')
                        errorSomeErase = True

        if errorSomeErase:
            print('幾つかのファイルの削除に失敗しました。')
            exit(1)
        else:
            print('アンインストールは正常に終了しました。')
            exit(0)
    #########################################################################
    else:  # インストール
        #########################################################################
        for (dirPath, dirNames, fileNames) in os.walk(filesDirPath):

            installToDirPath = dirPath[len(filesDirPath):]
            if installToDirPath.startswith('/'):
                installToDirPath = installToDirPath[1:]

            for dirName in dirNames:
                newDirPath = os.path.join(installTargetPath, installToDirPath, dirName)
                if os.path.isdir(newDirPath) and os.access(newDirPath, os.W_OK):
                    print('ディレクトリ「' + newDirPath + '」は既に存在します。')
                    continue

                try:
                    os.mkdir(newDirPath)
                    print('mkdir : ' + newDirPath)
                except:
                    print('ディレクトリ「' + newDirPath + '」の作成に失敗しました。')
                    exit(1)

            for fileName in fileNames:
                newFilePath = os.path.join(installTargetPath, installToDirPath, fileName)
                copyFromPath = os.path.join(dirPath, fileName)

                try:
                    if os.path.islink(copyFromPath):
                        if os.path.exists(newFilePath):
                            os.remove(newFilePath)

                        linkStr = os.readlink(copyFromPath)
                        os.symlink(linkStr, newFilePath)
                        print('Symbolic link from : ' + copyFromPath)
                        print('Symbolic link to : ' + newFilePath)
                    else:
                        shutil.copy(copyFromPath, newFilePath)
                        print('file copy from : ' + copyFromPath)
                        print('file copy to : ' + newFilePath)
                except:
                    print('ファイル「' + newFilePath + '」の作成に失敗しました。')
                    exit(1)

        print('インストールが正常に終了しました。')
    #########################################################################
    exit(0)
