SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL';

CREATE SCHEMA IF NOT EXISTS `addressBook` DEFAULT CHARACTER SET utf8 ;
USE `addressBook` ;

-- -----------------------------------------------------
-- Table `addressBook`.`person`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `addressBook`.`person` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `lastName` VARCHAR(45) NOT NULL ,
  `lastNameKana` VARCHAR(45) NOT NULL ,
  `firstName` VARCHAR(45) NOT NULL ,
  `firstNameKana` VARCHAR(45) NOT NULL ,
  `age` INT UNSIGNED NOT NULL ,
  `sex` ENUM('male','female') NOT NULL DEFAULT male ,
  `birthday` DATE NOT NULL ,
  PRIMARY KEY (`id`) ,
  UNIQUE INDEX `id_UNIQUE` (`id` ASC) )
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `addressBook`.`area`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `addressBook`.`area` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `areaName` VARCHAR(128) NOT NULL ,
  PRIMARY KEY (`id`) ,
  UNIQUE INDEX `id_UNIQUE` (`id` ASC) )
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `addressBook`.`address`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `addressBook`.`address` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `personId` INT UNSIGNED NOT NULL ,
  `zipCode` CHAR(9) NOT NULL DEFAULT '000-0000' ,
  `areaCode` INT UNSIGNED NOT NULL ,
  `address1` VARCHAR(512) NOT NULL ,
  `address2` VARCHAR(512) NULL ,
  `comment` VARCHAR(1024) NULL ,
  PRIMARY KEY (`id`) ,
  UNIQUE INDEX `id_UNIQUE` (`id` ASC) ,
  INDEX `fk_person_id` (`personId` ASC) ,
  INDEX `fk_area_id` (`areaCode` ASC) ,
  CONSTRAINT `fk_person_id`
    FOREIGN KEY (`personId` )
    REFERENCES `addressBook`.`person` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_area_id`
    FOREIGN KEY (`areaCode` )
    REFERENCES `addressBook`.`area` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `addressBook`.`phone`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `addressBook`.`phone` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `personId` INT UNSIGNED NOT NULL ,
  `code1` INT UNSIGNED NOT NULL ,
  `code2` INT UNSIGNED NOT NULL ,
  `phineType` ENUM('Land Line','Mobile', 'Fax') NOT NULL DEFAULT Land Line ,
  PRIMARY KEY (`id`) ,
  UNIQUE INDEX `id_UNIQUE` (`id` ASC) ,
  INDEX `fk_person_id` (`personId` ASC) ,
  CONSTRAINT `fk_person_id`
    FOREIGN KEY (`personId` )
    REFERENCES `addressBook`.`person` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;



SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
