#!/usr/bin/env python
# This Python file uses the following encoding: utf-8
import sys
from PySide6.QtCore import Slot
from PySide6.QtWidgets import QApplication, QDialog
from PySide6.QtUiTools import loadUiType

class ColorDialog(QDialog):
    def __init__(self):
        # 親クラスの初期化
        super().__init__()

        # ダイアログファイルを読み込み専用でオープンし、ダイアログデータの読み込み
        generated_class, base_class = loadUiType("dialog.ui")
        self.form = generated_class()
        self.form.setupUi(self)

        #　Spin Box に　シグナル／スロット を設定
        self.form.redSpinBox.valueChanged.connect(self.change_color)
        self.form.greenSpinBox.valueChanged.connect(self.change_color)
        self.form.blueSpinBox.valueChanged.connect(self.change_color)


    # 色が変更された時に実行するスレッド
    @Slot(int)
    def change_color(self, value):
        # RGB を取得
        red = self.form.redSpinBox.value()
        green = self.form.greenSpinBox.value()
        blue = self.form.blueSpinBox.value()

        # スタイルシートの作成
        css = f'background-color: #{red:02x}{green:02x}{blue:02x}'

        self.form.colorLabel.setStyleSheet(css)


if __name__ == "__main__":

    # アプリケーションの開始
    app = QApplication(sys.argv)

    # ダイアログの生成
    window = ColorDialog()

    # ダイアログの表示
    window.show()

    # イベントループの実行
    sys.exit(app.exec())
