#!/usr/bin/env python
# This Python file uses the following encoding: utf-8
import sys
import re
from PySide6.QtCore import Slot
from PySide6.QtWidgets import QApplication, QDialog
from PySide6.QtUiTools import loadUiType

class ColorDialog(QDialog):
    def __init__(self):
        # 親クラスの初期化
        super().__init__()

        # ダイアログファイルを読み込み専用でオープンし、ダイアログデータの読み込み
        generated_class, base_class = loadUiType("dialog.ui")
        self.form = generated_class()
        self.form.setupUi(self)

        # パスワード結果ラベルを設定
        value = self.form.resultsLabel.property('noPassword')
        self.form.resultsLabel.setText(value)

        #　Line Edit に　シグナル／スロット を設定
        self.form.numLineEdit.textChanged.connect(self.num_change)
        self.form.hiraganaLineEdit.textChanged.connect(self.hiragana_change)
        self.form.katakanaLineEdit.textChanged.connect(self.katakana_change)
        self.form.passwordLineEdit.textChanged.connect(self.password_change)
        self.form.confirmLineEdit.textChanged.connect(self.password_change)

    # 文字列（数字）が変更された時に実行するスレッド
    @Slot(str)
    def num_change(self, value):
        match = re.search(r'[^0-9]', value)
        if match:
            value = re.sub(r'[^0-9]', '', value)
            self.form.numLineEdit.setText(value)

    # 文字列（ひらがな）が変更された時に実行するスレッド
    @Slot(str)
    def hiragana_change(self, value):
        match = re.search(r'[^あ-んざ-ぞだ-どば-ぼぱ-ぽぁ-ぉゃ-ょっー]', value)
        if match:
            value = re.sub(r'[^あ-んざ-ぞだ-どば-ぼぱ-ぽぁ-ぉゃ-ょっー]', '', value)
            self.form.hiraganaLineEdit.setText(value)


    # 文字列（カタカナ）が変更された時に実行するスレッド
    @Slot(str)
    def katakana_change(self, value):
        match = re.search(r'[^ア-ンザ-ゾダ-ドバ-ボパ-ポァ-ォャ-ョッー]', value)
        if match:
            value = re.sub(r'[^ア-ンザ-ゾダ-ドバ-ボパ-ポァ-ォャ-ョッー]', '', value)
            self.form.katakanaLineEdit.setText(value)

    # 文字列（パスワード）が変更された時に実行するスレッド
    @Slot(str)
    def password_change(self, value):
        if 1 > len(self.form.passwordLineEdit.text()):
            value = self.form.resultsLabel.property('noPassword')
            self.form.resultsLabel.setText(value)
        elif self.form.passwordLineEdit.text() == self.form.confirmLineEdit.text():
            value = self.form.resultsLabel.property('matchPassword')
            self.form.resultsLabel.setText(value)
        else:
            value = self.form.resultsLabel.property('missmatchPassword')
            self.form.resultsLabel.setText(value)

if __name__ == "__main__":

    # アプリケーションの開始
    app = QApplication(sys.argv)

    # ダイアログの生成
    window = ColorDialog()

    # ダイアログの表示
    window.show()

    # イベントループの実行
    sys.exit(app.exec())
